<script>
	(function ()
	{
		let integrationVariant;

		window.addEventListener('load', function ()
		{
			initFreePlusLinks();
			initTabs();
			setTab("<?php echo $smartarget_whatsapp_contact_us_data['integration_variant'] ?>");
		});

		function initFreePlusLinks ()
		{
			let freePlusLinks = document.querySelectorAll('.free-plus-link');
			Array.prototype.forEach.call(freePlusLinks, function (link)
			{
				link.addEventListener('click', function (e)
				{
					setTab('free_plus');
				})
			});
		}

		function setTab (tabName)
		{
			integrationVariant = tabName;

			tabName = tabName || 'free';
			let tabsContents = document.querySelectorAll('.tab-content');
			let tabs = document.querySelectorAll('.tab');
			let input = document.querySelector('input[name="integration_variant"]');

			input.value = tabName;

			Array.prototype.forEach.call(tabsContents, function (tabContent)
			{
				if (tabContent.classList.contains(tabName))
				{
					tabContent.classList.add('visible');
				}
				else
				{
					tabContent.classList.remove('visible');
				}
			});

			Array.prototype.forEach.call(tabs, function (tab)
			{
				if (tab.classList.contains(tabName))
				{
					tab.classList.add('visible');
				}
				else
				{
					tab.classList.remove('visible');
				}
			});
		}

		function initTabs ()
		{
			let freePlusTab = document.querySelector('.tab.free_plus'),
				freeTab = document.querySelector('.tab.free');

			if (freePlusTab !== null)
			{
				freePlusTab.addEventListener('click', function ()
				{
					setTab('free_plus');
				})
			}

			if (freeTab !== null)
			{
				freeTab.addEventListener('click', function ()
				{
					setTab('free');
				})
			}
		}
	})();
</script>

<div id="content" class="sm-wrapper panel panel-default">

	<h1>Complete integration for <?=$appName?></h1>

	<?php echo $smartarget_whatsapp_contact_us_form['form_open'];?>

	<?php include 'tabs.tpl' ?>

	<div class="tab-content free_plus visible">
		<?php include 'free_plus.tpl' ?>
	</div>

	<div class="tab-content free">
		<?php include 'free.tpl' ?>
	</div>

	<button id="sm-submit" class="sm-submit-btn">Save changes</button>

	</form>


</div>
